<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8"> <!-- utf-8 works for most cases -->
    <meta name="viewport" content="width=device-width"> <!-- Forcing initial-scale shouldn't be necessary -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge"> <!-- Use the latest (edge) version of IE rendering engine -->
    <meta name="x-apple-disable-message-reformatting"> <!-- Disable auto-scale in iOS 10 Mail entirely -->
    <title></title> <!-- The title tag shows in email notifications, like Android 4.4. -->

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;700&family=Tajawal:wght@200;300;400;500;700;800;900&display=swap"
        rel="stylesheet">

    <!-- CSS Reset : BEGIN -->
    <style>
        /* What it does: Remove spaces around the email design added by some email clients. */
        /* Beware: It can remove the padding / margin and add a background color to the compose a reply window. */
        html,
        body {
            margin: 0 auto !important;
            padding: 0 !important;
            height: 100% !important;
            width: 100% !important;
            background: #f1f1f1;
            font-family: 'Cairo', sans-serif;

        }

        /* What it does: Stops email clients resizing small text. */
        * {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
        }

        /* What it does: Centers email on Android 4.4 */
        div[style*="margin: 16px 0"] {
            margin: 0 !important;
        }

        /* What it does: Stops Outlook from adding extra spacing to tables. */
        table,
        td {
            mso-table-lspace: 0pt !important;
            mso-table-rspace: 0pt !important;
        }

        /* What it does: Fixes webkit padding issue. */
        table {
            border-spacing: 0 !important;
            border-collapse: collapse !important;
            table-layout: fixed !important;
            margin: 0 auto !important;
        }

        /* What it does: Uses a better rendering method when resizing images in IE. */
        img {
            -ms-interpolation-mode: bicubic;
        }

        /* What it does: Prevents Windows 10 Mail from underlining links despite inline CSS. Styles for underlined links should be inline. */
        a {
            text-decoration: none;
        }

        /* What it does: A work-around for email clients meddling in triggered links. */
        *[x-apple-data-detectors],
        /* iOS */
        .unstyle-auto-detected-links *,
        .aBn {
            border-bottom: 0 !important;
            cursor: default !important;
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }


        .a6S {
            display: none !important;
            opacity: 0.01 !important;
        }


        .im {
            color: inherit !important;
        }


        img.g-img+div {
            display: none !important;
        }


        @media only screen and (min-device-width: 320px) and (max-device-width: 374px) {
            u~div .email-container {
                min-width: 320px !important;
            }
        }

        /* iPhone 6, 6S, 7, 8, and X */
        @media only screen and (min-device-width: 375px) and (max-device-width: 413px) {
            u~div .email-container {
                min-width: 375px !important;
            }
        }

        /* iPhone 6+, 7+, and 8+ */
        @media only screen and (min-device-width: 414px) {
            u~div .email-container {
                min-width: 414px !important;
            }
        }
    </style>

    <!-- CSS Reset : END -->

    <!-- Progressive Enhancements : BEGIN -->
    <style>
        .primary {
            background: #35537d;
        }

        .bg_white {
            background: #ffffff;
        }

        .bg_light {
            background: #fafafa;
        }

        .bg_black {
            background: #000000;
        }

        .bg_dark {
            background: rgba(0, 0, 0, .8);
        }

        .email-section {
            padding: 2.5em;
        }

        /*BUTTON*/
        .btn {
            padding: 10px 15px;
            display: inline-block;
        }

        .btn.btn-primary {
            border-radius: 5px;
            background: #35537d;
            color: #ffffff;
        }

        .btn.btn-white {
            border-radius: 5px;
            background: #ffffff;
            color: #000000;
        }

        .btn.btn-white-outline {
            border-radius: 5px;
            background: transparent;
            border: 1px solid #fff;
            color: #fff;
        }

        .btn.btn-black-outline {
            border-radius: 0px;
            background: transparent;
            border: 2px solid #000;
            color: #000;
            font-weight: 700;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {

            color: #000000;
            margin-top: 0;
            font-weight: 400;
        }

        body {

            font-weight: 400;
            font-size: 15px;
            line-height: 1.8;
            color: rgba(0, 0, 0, .4);
        }

        a {
            color: #35537d;
        }

        /* table {} */

        /*LOGO*/

        .logo h1 {
            margin: 0;
        }

        .logo h1 a {
            color: #35537d;
            font-size: 24px;
            font-weight: 700;

        }

        /*HERO*/
        .hero {
            position: relative;
            z-index: 0;
        }

        .hero .text {
            color: rgba(0, 0, 0, .3);
        }

        .hero .text h2 {
            color: #000;
            font-size: 40px;
            margin-bottom: 0;
            font-weight: 400;
            line-height: 1.4;
        }

        .hero .text h3 {
            font-size: 24px;
            font-weight: 300;
        }

        .hero .text h2 span {
            font-weight: 600;
            color: #35537d;
        }


        /*HEADING SECTION*/
        /* .heading-section {} */

        .heading-section h2 {
            color: #000000;
            font-size: 28px;
            margin-top: 0;
            line-height: 1.4;
            font-weight: 400;
        }

        .heading-section .subheading {
            margin-bottom: 20px !important;
            display: inline-block;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 2px;
            color: rgba(0, 0, 0, .4);
            position: relative;
        }

        .heading-section .subheading::after {
            position: absolute;
            left: 0;
            right: 0;
            bottom: -10px;
            content: '';
            width: 100%;
            height: 2px;
            background: #35537d;
            margin: 0 auto;
        }

        .heading-section-white {
            color: rgba(255, 255, 255, .8);
        }

        .heading-section-white h2 {
            line-height: 1;
            padding-bottom: 0;
        }

        .heading-section-white h2 {
            color: #ffffff;
        }

        .heading-section-white .subheading {
            margin-bottom: 0;
            display: inline-block;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 2px;
            color: rgba(255, 255, 255, .4);
        }


        ul.social {
            padding: 0;
        }

        ul.social li {
            display: inline-block;
            margin-right: 10px;
        }

        /*FOOTER*/

        .footer {
            border-top: 1px solid rgba(0, 0, 0, .05);
            color: rgba(0, 0, 0, .5);
        }

        .footer .heading {
            color: #000;
            font-size: 20px;
        }

        .footer ul {
            margin: 0;
            padding: 0;
        }

        .footer ul li {
            list-style: none;
            margin-bottom: 10px;
        }

        .footer ul li a {
            color: rgba(0, 0, 0, 1);
        }


        @media screen and (max-width: 500px) {}
    </style>


</head>

<body width="100%"
    style="margin: 0; padding: 0 !important; mso-line-height-rule: exactly; background-color: #f1f1f1;">
    <center style="width: 100%; background-color: #f1f1f1;">
        <div
            style="display: none; font-size: 1px;max-height: 0px; max-width: 0px; opacity: 0; overflow: hidden; mso-hide: all; font-family: sans-serif;">

        </div>
        <div style="max-width: 600px; margin: 0 auto;" class="email-container">
            <!-- BEGIN BODY -->
            <table align="center" role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%"
                style="margin: auto;">
                <tr>
                    <td valign="top" class="bg_white" style="padding: 1em 2.5em 0 2.5em;">
                        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
                            <tr>
                                <td class="logo" style="text-align: center;">
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr><!-- end tr -->
                <tr>
                    <td valign="middle" class="hero bg_white" style="padding: 3em 0 2em 0;">
                        <img src="data:image/jpeg;base64,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"
                            alt=""
                            style="width: 300px; max-width: 600px; height: auto; margin: auto; display: block;">
                    </td>
                </tr><!-- end tr -->
                <tr>
                    <td valign="middle" class="hero bg_white" style="padding: 2em 0 4em 0;">
                        <table>
                            <tr>
                                <td>
                                    <div class="text" style="padding: 0 2.5em; text-align: center;">
                                        <h2>منصة الخبير الإداري</h2>
                                        <h2>مرحبا بك </h2>
                                        <p>
                                            {{ $content }}
                                        </p>
                                        <p>
                                            نتمنى لك كل التوفيق
                                        </p>
                                        @php
                                            $route = explode('/', $route);
                                            $parameter = null;
                                            $name = $route[0];
                                            $parameter = $route;
                                            array_shift($parameter);
                                        @endphp

                                        <p>
                                            <a href="@if (count($route) == 1) {{ route($name) }}@else{{ route($name, $parameter) }} @endif"
                                                class="btn btn-primary" style="border-radius:10px;">
                                                الدخول للمنصة
                                            </a>
                                        </p>

                                        <br>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr><!-- end tr -->
                <!-- 1 Column Text + Button : END -->
            </table>


        </div>
    </center>
</body>

</html>
